IF OBJECT_ID('VW_CLI_STATUS_LGPD', 'V') IS NOT NULL
    DROP VIEW VW_CLI_STATUS_LGPD
GO

CREATE VIEW VW_CLI_STATUS_LGPD AS

select c.CD_EMP, c.CD_FILIAL, c.CD_CLI, 'Aceite do termo LGPD no solicitado devido a configurao' as status_lgpd
from  RC_CLI c 
INNER JOIN GLB_CONFIG_IGNORA_ACEITE_LGPD_CLI i on i.CD_CLI = c.CD_CLI
where (c.ACEITE_LGPD = 0 or c.ACEITE_LGPD is NULL)

union

select c.CD_EMP, c.CD_FILIAL, c.CD_CLI, 'Aceite do termo LGPD pendente de resposta' as status_lgpd
from  RC_CLI c 
LEFT JOIN RC_CLI_CONV_RC_CLI o on (o.CD_CLI = c.CD_CLI) -- convenio
where (c.ACEITE_LGPD = 0 or c.ACEITE_LGPD IS NULL)
and exists(select ATIVA_VALID_CLIENTES_CONVENIO from  GLB_CONFIG_ACEITE_LGPD where ATIVA_VALID_CLIENTES_CONVENIO = 1)
and not exists (select g.CD_CLI from GLB_CONFIG_IGNORA_ACEITE_LGPD_CLI g where g.CD_CLI = c.CD_CLI )
and not exists (select r.CD_CLI from RC_CLI_CONV_RC_CLI r where (r.CD_CLI = c.CD_CLI))
and not exists (select b.CD_CONV from GLB_CONFIG_IGNORA_ACEITE_LGPD_CONV b
                INNER JOIN (select r.CD_CONV from RC_CLI_CONV_RC_CLI r where (r.CD_CLI = c.CD_CLI)) j
				        on b.CD_CONV = j.CD_CONV)

union

select c.CD_EMP, c.CD_FILIAL, c.CD_CLI, 'Aceite do termo LGPD pendente de resposta' as status_lgpd
from  RC_CLI c 
LEFT JOIN PDV_ACEITE_LGPD_RC_CLI AC ON C.CD_CLI = AC.CD_CLI
LEFT JOIN RC_CLI_CONV_RC_CLI o on  (o.CD_CLI = c.CD_CLI) -- crediario
where (c.ACEITE_LGPD = 0 or c.ACEITE_LGPD is NULL)
and exists(select ATIVA_VALID_CLIENTES_CREDIARIO from  GLB_CONFIG_ACEITE_LGPD where ATIVA_VALID_CLIENTES_CREDIARIO = 1)
and not exists (select g.CD_CLI from GLB_CONFIG_IGNORA_ACEITE_LGPD_CLI g where g.CD_CLI = c.CD_CLI )
and not exists (select r.CD_CLI from RC_CLI_CREDIARIO r where (r.CD_CLI = c.CD_CLI))
and not exists (select b.CD_CONV from GLB_CONFIG_IGNORA_ACEITE_LGPD_CONV b
                INNER JOIN (select r.CD_CONV from RC_CLI_CONV_RC_CLI r where (r.CD_CLI = c.CD_CLI)) j
				        on b.CD_CONV = j.CD_CONV)

union

select c.CD_EMP, c.CD_FILIAL, c.CD_CLI, 'Aceite do termo LGPD pendente de resposta' as status_lgpd
from  RC_CLI c 
where (c.ACEITE_LGPD = 0 or c.ACEITE_LGPD is NULL)
and exists(select ATIVA_VALID_CLIENTES_AVISTA from  GLB_CONFIG_ACEITE_LGPD where ATIVA_VALID_CLIENTES_AVISTA = 1)
and not exists (select g.CD_CLI from GLB_CONFIG_IGNORA_ACEITE_LGPD_CLI g where g.CD_CLI = c.CD_CLI )

union

select c.CD_EMP, c.CD_FILIAL, c.CD_CLI, CONVERT(VARCHAR,'Aceite do termo LGPD aceito em ' + 
     FORMAT(i.DT_HR_ACEITE_LGPD,'dd/MM/yyyy HH:mm:ss', 'pt-br') + ', no Doc: ' +
	 Cast(i.DOCUMENTO_ACEITE as varchar) + ', pelo Usurio: ' + Cast(i.CD_USU as varchar) + ' - ' + u.NM_USU COLLATE database_default)   as status_lgpd
from  RC_CLI c 
INNER JOIN PDV_ACEITE_LGPD_RC_CLI i on (i.CD_CLI = c.CD_CLI)
INNER JOIN GLB_USU u  on u.CD_USU = i.CD_USU	
where (c.ACEITE_LGPD = 1 and i.ACEITE_LGPD = 1)

union

select c.CD_EMP, c.CD_FILIAL, c.CD_CLI, CONVERT(VARCHAR,'Aceite do termo LGPD recusado em ' + 
     FORMAT(i.DT_HR_ACEITE_LGPD,'dd/MM/yyyy HH:mm:ss', 'pt-br') + ', pelo Usurio: ' + Cast(i.CD_USU as varchar) + ' - ' + u.NM_USU COLLATE database_default) as status_lgpd
from  RC_CLI c 
INNER JOIN PDV_ACEITE_LGPD_RC_CLI i on (i.CD_CLI = c.CD_CLI)
INNER JOIN GLB_USU u  on u.CD_USU = i.CD_USU			
where (c.ACEITE_LGPD = 2 and i.ACEITE_LGPD = 2)

union

select c.CD_EMP, c.CD_FILIAL, c.CD_CLI, CONVERT(VARCHAR,'Aceite do termo LGPD recusado em ' + 
  FORMAT(i.DT_HR_ACEITE_LGPD,'dd/MM/yyyy HH:mm:ss', 'pt-br') + ', pelo Usurio  ' + Cast(i.CD_USU as varchar) + ' - ' + u.NM_USU COLLATE database_default + ', ' +
  'e anonimizao pendente devido a cheque e/ou ttulo ativo') as status_lgpd
from  RC_CLI c 
INNER JOIN PDV_ACEITE_LGPD_RC_CLI i on (i.CD_CLI = c.CD_CLI) 
LEFT JOIN GLB_USU u  on u.CD_USU = i.CD_USU	
where (c.ACEITE_LGPD = 3 and i.ACEITE_LGPD = 2);
















